<?php
namespace NumbersPHP\Tests;

use NumbersPHP\Calculus;
use NumbersPHP\Numbers;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-02-22 at 19:16:10.
 */
class CalculusTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Calculus
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new Calculus;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    /**
     * @covers NumbersPHP\Calculus::pointDiff
     */
    public function testPointDiff()
    {
        $testCalculusPointDiffTestFunc = function ($x) {
            return 2 * $x + 2;
        };
        $this->assertTrue(
            2 - \NumbersPHP\Calculus::pointDiff($testCalculusPointDiffTestFunc, 5) < \NumbersPHP\Numbers::EPSILON
        );
    }

    /**
     * @covers NumbersPHP\Calculus::riemann
     */
    public function testRiemann()
    {
        $testCalculusRiemannTestFunc = function ($x) {
            return 2 * $x * $x;
        };

        $this->assertEquals(
            570000,
            \NumbersPHP\Calculus::riemann($testCalculusRiemannTestFunc, 0, 100, 10)
        );

    }

    /**
     * @covers NumbersPHP\Calculus::adaptiveSimpson
     */
    public function testAdaptiveSimpson()
    {
        $testCalculusAdaptiveSimpsonTestFunc = function ($x) {
            return 2 * $x * $x;
        };

        $this->assertTrue(
            \NumbersPHP\Basic::numbersEqual(
                \NumbersPHP\Calculus::adaptiveSimpson($testCalculusAdaptiveSimpsonTestFunc, 0, 100),
                666666.66667,
                \NumbersPHP\Numbers::EPSILON
            )
        );

        /**
         * this does not work
         */
        /*
             $this->assertEquals(
                666666.666667,
                \NumbersPHP\Calculus::adaptiveSimpson($testCalculusAdaptiveSimpsonTestFunc, 0, 100),
                'adaptive simpson should return an estimated definite integral of a function'
            );
        */
    }

    /**
     * @covers NumbersPHP\Calculus::limit
     */
    public function testLimit()
    {
        $testCalculusLimitTestFunc = function ($x) {
            return $x * $x * sin(2 * $x);
        };
        $this->assertEquals(
            91.2945250728,
            \NumbersPHP\Calculus::limit($testCalculusLimitTestFunc, 10, 'middle')
        );
    }

    /**
     * @covers NumbersPHP\Calculus::stirlingGamma
     */
    public function testStirlingGamma()
    {
        $this->assertFalse(\NumbersPHP\Numbers::EPSILON <= 5.69718714897717 - \NumbersPHP\Calculus::stirlingGamma(0.1));
        $this->assertFalse(\NumbersPHP\Numbers::EPSILON <= 3.3259984240223925 - \NumbersPHP\Calculus::stirlingGamma(0.2));
        $this->assertFalse(\NumbersPHP\Numbers::EPSILON <= 2.3625300362696198 - \NumbersPHP\Calculus::stirlingGamma(0.3));
        $this->assertFalse(\NumbersPHP\Numbers::EPSILON <= 0.8426782594483921 - \NumbersPHP\Calculus::stirlingGamma(1.3));
    }

    /**
     * @covers NumbersPHP\Calculus::lanczosGamma
     */
    public function testLanczosGamma()
    {
        $this->assertFalse(\NumbersPHP\Numbers::EPSILON <= 9.513507698668736 - \NumbersPHP\Calculus::lanczosGamma(0.1));

        $this->assertFalse(\NumbersPHP\Numbers::EPSILON <= 4.590843711998803 - \NumbersPHP\Calculus::lanczosGamma(0.2));

        $this->assertFalse(
            \NumbersPHP\Numbers::EPSILON <= 2.9915689876875904 - \NumbersPHP\Calculus::lanczosGamma(0.3)
        );

        $this->assertFalse(
            \NumbersPHP\Numbers::EPSILON <= 0.8974706963062777 - \NumbersPHP\Calculus::lanczosGamma(1.3)
        );

    }
}
