<?php
/*
 * Copyright (c) 2025, Tribal Limited
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Zenario, Tribal Limited nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL TRIBAL LTD BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
if (!defined('NOT_ACCESSED_DIRECTLY')) exit('This file may not be directly accessed');


ze::$vars['docId'] =
ze::$vars['userId'] =
ze::$vars['companyId'] =
ze::$vars['locationId'] = 0;

ze::$vars['countryId'] = '';

//Add some vars that any non-hierarchical plugin can just use
ze::$vars['id'] = (int) ($_REQUEST['id'] ?? 0);
ze::$vars['date'] = $_REQUEST['date'] ?? '';

$status = require ze::editionInclude('checkRequestVars', $continueFrom = 'zenario_pro_features');
if (!$status) {
	return $status;
}

$zclmPrefix = ze\module::prefix('zenario_company_locations_manager');
$zlmPrefix = ze\module::prefix('zenario_location_manager');

$companyWasFromLocation = false;
$countryWasFromLocation = false;

if ($zlmPrefix) {
	//Look for the location ID in the URL, if it's not yet been set
	if (!ze::$vars['locationId']) {
		ze::$vars['locationId'] = (int) ($_REQUEST['locationId'] ?? 0);
	}
	//If a location is selected, ensure the country id is set from that location,
	//otherwise look for it in the URL
	if (ze::$vars['locationId']) {
		ze::$vars['countryId'] = ze\row::get($zlmPrefix. 'locations', 'country_id', ze::$vars['locationId']);
		$countryWasFromLocation = true;
	} else {
		ze::$vars['countryId'] = $_REQUEST['countryId'] ?? '';
	}
}

if ($zclmPrefix) {
	if (!ze::$vars['companyId']) {
		
		if (ze::$vars['locationId']
		 && (ze::$vars['companyId'] = ze\row::get($zclmPrefix. 'company_location_link', 'company_id', ['location_id' => ze::$vars['locationId']]))) {
			$companyWasFromLocation = true;
		
		} elseif (!empty($_REQUEST['companyId'])) {
			ze::$vars['companyId'] = (int) $_REQUEST['companyId'];
		}
	}
}

if (!ze::$vars['docId']) {
	if (!empty($_REQUEST['docId'])) {
		ze::$vars['docId'] = (int) $_REQUEST['docId'];
	}
}

if (ze::$vars['docId'] && !ze\user::can('view', 'document', ze::$vars['docId'])) {
	return ZENARIO_403_NO_PERMISSION;
}

if (!ze::$vars['userId']) {
	if (!empty($_REQUEST['userId'])) {
		ze::$vars['userId'] = (int) $_REQUEST['userId'];
	}
}

//If a countryId, companyId and/or locationId is in the URL, check the current visitor is allowed to see that company and/or location
if ((ze::$vars['userId'] && !ze\user::can('view', 'user', ze::$vars['userId']))
 || (!$countryWasFromLocation && ze::$vars['countryId'] && !ze\user::can('view', 'country', ze::$vars['countryId']))
 || (!$companyWasFromLocation && ze::$vars['companyId'] && !ze\user::can('view', 'company', ze::$vars['companyId']))
 || (ze::$vars['locationId'] && !ze\user::can('view', 'location', ze::$vars['locationId']))) {
	return ZENARIO_403_NO_PERMISSION;
}

//If the assetwolf module is running and there's no data pool in the URL,
//but there's a location in the URL that the visitor has permissions to see,
//then try to use the data pool for the location.
if (isset($a2Prefix) && $a2Prefix
 && !ze::$vars['dataPoolId']
 && !empty(ze::$vars['locationId'])) {
	ze::$vars['dataPoolId'] = (int) ze\row::get(
		$a2Prefix. 'nodes',
		'id',
		['owner_type' => 'location', 'owner_id' => ze::$vars['locationId'], 'is_data_pool' => 1, 'parent_id' => 0]
	);
	
	//N.b. if the visitor has permissions to see a location then they should also be able to see the data pool for
	//the location, we don't need another ze\user::can() check here.
}

return true;