<?php
/*
 * Copyright (c) 2025, Tribal Limited
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Zenario, Tribal Limited nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL TRIBAL LTD BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
if (!defined('NOT_ACCESSED_DIRECTLY')) exit('This file may not be directly accessed');


//Add a table to store custom locations data
ze\dbAdm::revision(124
, <<<_sql
	DROP TABLE IF EXISTS [[DB_PREFIX]][[ZENARIO_LOCATION_MANAGER_PREFIX]]locations_custom_data
_sql

, <<<_sql
	CREATE TABLE [[DB_PREFIX]][[ZENARIO_LOCATION_MANAGER_PREFIX]]locations_custom_data (
		`location_id` int(10) unsigned NOT NULL,
		PRIMARY KEY (`location_id`)
	) ENGINE=[[ZENARIO_TABLE_ENGINE]] CHARSET=[[ZENARIO_TABLE_CHARSET]] COLLATE=[[ZENARIO_TABLE_COLLATION]]
_sql
 
);

if (ze\dbAdm::needRevision(166)) {
	
	//Add or update a record in the custom_datasets table with the correct details
	$datasetId = ze\datasetAdm::register(
		'Locations',
		ZENARIO_LOCATION_MANAGER_PREFIX. 'locations_custom_data',
		ZENARIO_LOCATION_MANAGER_PREFIX. 'locations',
		'zenario_location_manager__location',
		'zenario__locations/panel',
		''
	);
	
	
	//Register system fields
	//(System fields are registered automatically when an admin views the datasets panel in Organizer, so this step
	// is optional, but when they are registered automatically they default to the "other_system_field" type and are
	// not selectable in things such as User Forms. Specifically registering them like this will ensure they are
	// usable.)
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'external_id', 'external_id');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'name', 'description', 'none', '', false, true);
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'address_line_1', 'address1');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'address_line_2', 'address2');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'locality', 'locality');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'city', 'city');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'state', 'state');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'postcode', 'postcode');
	ze\datasetAdm::registerSystemField($datasetId, 'centralised_select', 'details', 'country', 'country_id', 'none', 'zenario_country_manager::getActiveCountries');
	ze\datasetAdm::registerSystemField($datasetId, 'dataset_picker', 'details', 'region');
	ze\datasetAdm::registerSystemField($datasetId, 'checkbox', 'details', 'hide_pin', 'hide_pin');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'marker_lng', 'latitude');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'marker_lat', 'longitude');
	ze\datasetAdm::registerSystemField($datasetId, 'date', 'details', 'last_updated', 'last_updated');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'last_updated_by', 'last_updated_admin_id');
	
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'phone', 'phone');
	ze\datasetAdm::registerSystemField($datasetId, 'text', 'details', 'fax', 'fax');
	ze\datasetAdm::registerSystemField($datasetId, 'url', 'details', 'url', 'url');
	ze\datasetAdm::registerSystemField($datasetId, 'textarea', 'summary', 'summary');
	ze\datasetAdm::registerSystemField($datasetId, 'date', 'details', 'url last accessed', 'last_accessed');
	ze\datasetAdm::registerSystemField($datasetId, 'centralised_radios', 'details', 'status', 'status', 'none', 'zenario_location_manager::locationStatus');
	
	//sectors
	
	ze\datasetAdm::registerSystemField($datasetId, 'checkboxes', 'sectors', 'sectors', 'sectors');
	
	ze\datasetAdm::registerSystemField($datasetId, 'centralised_select', 'details', 'timezone', 'timezone', 'none', 'zenario_timezones::getTimezones');

	ze\dbAdm::revision(166);
}

if (ze\dbAdm::needRevision(173)) {
	//Remove the "Last edited" and "Last edited by" fields.
	//They are no longer in use, and so junk data can be deleted.

	//Get the dataset ID...
	$datasetId = ze\datasetAdm::register(
		'Locations',
		ZENARIO_LOCATION_MANAGER_PREFIX. 'locations_custom_data',
		ZENARIO_LOCATION_MANAGER_PREFIX. 'locations',
		'zenario_location_manager__location',
		'zenario__locations/panel',
		''
	);

	//... and then delete the dataset fields, as well as any values
	//for 'last_updated' and 'last_updated_by' fields.
	$sql = "
		DELETE cdf.*, cdfv.*
		FROM " . DB_PREFIX . "custom_dataset_fields AS cdf
		LEFT JOIN " . DB_PREFIX . "custom_dataset_field_values AS cdfv
		ON cdfv.field_id = cdf.id
		WHERE cdf.is_system_field = 1
		AND cdf.field_name IN ('last_updated', 'last_updated_by')
		AND cdf.dataset_id = ". (int) $datasetId;
	ze\sql::update($sql);

	ze\dbAdm::revision(173);
}